#pragma once

#include <QImage>
#include <QMainWindow>
#include <QMessageBox>
#include <QTextDocument>

#include "aboug_dialog.h"
#include "calligraphy_process.h"

namespace Ui {

class MainWindow;

} // namespace Ui

class MainWindow : public QMainWindow {
public:
  MainWindow(QWidget *parent = nullptr);
  ~MainWindow();

private:
  std::unique_ptr<CalligraphyProcess> mCalligraphyProcess;
  void ensureCalligraphyProcess();

  Ui::MainWindow *mUi = nullptr;

  QImage mCalligraphyImage;
  QImage mCalligraphyImageWithBoxes;

  QTextDocument mDocument;
  QList<int> mCalligrapherIndices;
  int mCurrentCalligrapher = -1; // no calligrapher is selected

  AboutDialog mAboutDialog;

  QMessageBox mErrorReport;

  void onCalligrapherBack();
  void onCalligrapherFront();
  void onSelectInput();
  void onConfirm();
  void onReset();
  void onAbout();

  void setCalligraphyImage(const QImage &image);

  void updateCalligraphers(int idx = -1);

  void reportError(const QString &msg);
};
